/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.ui.bonsai.table;

import com.ibm.hwmca.fw.ui.InvalidIdException;
import com.ibm.hwmca.ui.bonsai.earth.BonsaiTreeManager;
import com.ibm.hwmca.ui.bonsai.earth.BonsaiTreeNode;
import com.ibm.hwmca.ui.bonsai.earth.event.TreePropertyListener;
import com.ibm.hwmca.ui.bonsai.event.EventQueueListener;
import com.ibm.hwmca.ui.bonsai.servlet.util.UIRefreshManager;
import com.ibm.hwmca.ui.bonsai.servlet.util.UserObject;
import com.ibm.hwmca.ui.bonsai.table.TableData;
import com.ibm.hwmca.ui.bonsai.tree.NavigationTreeSelectionListener;
import com.ibm.psw.wcl.components.table.DefaultExtendedTableModel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ResourcesTableModel
extends DefaultExtendedTableModel
implements EventQueueListener,
NavigationTreeSelectionListener,
TreePropertyListener {
    private final Object DATA_LOCK = new Object();
    private String parentId;
    private TableData data;
    private boolean reloadPending = false;
    private List maxColumnKeys;
    private String workareaName;
    private UserObject userObj;

    public ResourcesTableModel(List maxColumnKeys, String workareaName, UserObject userObj) {
        this.maxColumnKeys = maxColumnKeys;
        this.workareaName = workareaName;
        this.userObj = userObj;
        this.setData(BonsaiTreeManager.getBonsaiTreeManager().getTreeNode(userObj.getTreeSelection()));
    }

    public UserObject getUserObject() {
        return this.userObj;
    }

    public void treeSelectionChanged(String oldSelection, String newSelection) {
        BonsaiTreeNode node = BonsaiTreeManager.getBonsaiTreeManager().getTreeNode(newSelection);
        if (node.getWorkarea().equals(this.workareaName)) {
            this.setData(node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setData(BonsaiTreeNode parent) {
        Object object = this.DATA_LOCK;
        synchronized (object) {
            this.reloadPending = false;
            this.rebuildData(parent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queueEmpty() {
        Object object = this.DATA_LOCK;
        synchronized (object) {
            if (this.reloadPending && this.isVisible()) {
                UIRefreshManager.refresh(2, this.userObj.getHMCSession());
            }
            this.reloadPending = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replace(BonsaiTreeNode oldNode, BonsaiTreeNode newNode) {
        Object object = this.DATA_LOCK;
        synchronized (object) {
            if (!newNode.isShown(this.userObj, false)) {
                if (oldNode.isShown(this.userObj, false) && this.performRemove(oldNode)) {
                    this.reloadPending = true;
                }
            } else if (this.performReplace(newNode)) {
                this.reloadPending = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(BonsaiTreeNode node) {
        Object object = this.DATA_LOCK;
        synchronized (object) {
            if (this.performRemove(node)) {
                this.reloadPending = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void statusChange(BonsaiTreeNode node) {
        Object object = this.DATA_LOCK;
        synchronized (object) {
            if (node.isShown(this.userObj, false)) {
                if (this.performReplace(node)) {
                    this.reloadPending = true;
                }
            } else if (this.performRemove(node)) {
                this.reloadPending = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uiinfoChange(BonsaiTreeNode node) {
        Object object = this.DATA_LOCK;
        synchronized (object) {
            if (node.isShown(this.userObj, false)) {
                if (this.performReplace(node)) {
                    this.reloadPending = true;
                }
            } else if (this.performRemove(node)) {
                this.reloadPending = true;
            }
        }
    }

    public void setSelectedRowsByIds(List rowIds) {
        Iterator i = rowIds.iterator();
        while (i.hasNext()) {
            this.setSelectedRowById((String)i.next());
        }
    }

    public boolean setSelectedRowById(String rowId) {
        int index = ResourcesTableModel.getRowIndex(rowId, this.data.getRowIds());
        if (index >= 0) {
            this.addSelectionInterval(index, index, null);
            return true;
        }
        return false;
    }

    public List getSelectedRowIds() {
        int[] rows = this.getSelectedModelRows();
        List rowIds = this.data.getRowIds();
        ArrayList selectedIds = new ArrayList(rows.length);
        for (int i = 0; i < rows.length; ++i) {
            selectedIds.add(rowIds.get(rows[i]));
        }
        return selectedIds;
    }

    private void rebuildData(BonsaiTreeNode parent) {
        this.parentId = parent.getId();
        this.data = new TableData(this.maxColumnKeys, BonsaiTreeManager.getBonsaiTreeManager().getTableProperties(this.parentId, this.userObj), false, "");
        this.setDataVector(this.data.getData(), this.data.getColumnNames(this.userObj.getLocale()));
    }

    private boolean performRemove(BonsaiTreeNode node) {
        BonsaiTreeNode bonsaiParent = node.getParent();
        boolean parentDisplayable = true;
        try {
            if (bonsaiParent != null) {
                parentDisplayable = bonsaiParent.isShown(this.userObj, true);
            }
        }
        catch (InvalidIdException iiEx) {
            parentDisplayable = false;
        }
        if (!parentDisplayable) {
            return this.performRemove(bonsaiParent);
        }
        String id = node.getId();
        List oldRowIds = this.data.getRowIds();
        if (oldRowIds.contains(id)) {
            boolean colsChanged = this.data.removeRow(id);
            if (colsChanged) {
                boolean emptyTable = this.data.isEmpty();
                List selectionIds = null;
                if (!emptyTable) {
                    selectionIds = this.getSelectedRowIds();
                }
                this.setDataVector(this.data.getData(), this.data.getColumnNames(this.userObj.getLocale()));
                if (!emptyTable) {
                    this.setSelectedRowsByIds(selectionIds);
                }
            } else {
                this.removeRow(ResourcesTableModel.getRowIndex(id, oldRowIds));
            }
            return true;
        }
        return false;
    }

    private boolean performReplace(BonsaiTreeNode node) {
        String id = node.getId();
        List oldRowIds = this.data.getRowIds();
        if (oldRowIds.contains(id)) {
            List selectionIds = this.getSelectedRowIds();
            boolean colsChanged = this.data.replaceRow(node.getTableProperties(this.userObj));
            if (colsChanged) {
                this.setDataVector(this.data.getData(), this.data.getColumnNames(this.userObj.getLocale()));
                this.setSelectedRowsByIds(selectionIds);
            } else {
                int index = ResourcesTableModel.getRowIndex(id, oldRowIds);
                this.removeRow(index);
                this.insertRow(index, this.data.getRowData(id));
                if (selectionIds.contains(id)) {
                    this.setSelectedRowById(id);
                }
            }
        } else if (this.isAncestorOfData(node) || node.getParent() != null && this.parentId.equals(node.getParent().getId())) {
            List selectionIds = this.getSelectedRowIds();
            this.rebuildData(BonsaiTreeManager.getBonsaiTreeManager().getTreeNode(this.parentId));
            this.setSelectedRowsByIds(selectionIds);
        } else {
            return false;
        }
        return true;
    }

    private boolean isAncestorOfData(BonsaiTreeNode node) {
        if (this.parentId.equals(node.getId())) {
            return true;
        }
        return node.isAncestor(BonsaiTreeManager.getBonsaiTreeManager().getTreeNode(this.parentId));
    }

    private static int getRowIndex(String id, List rowIds) {
        int index = 0;
        Iterator i = rowIds.iterator();
        while (i.hasNext()) {
            if (id.equals(i.next())) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    private boolean isVisible() {
        return this.userObj.isModelVisible(this.workareaName);
    }
}

